#pragma once

#include <vector>
//****************************************************************************************************************
//Tria reprezentujici zasobnik, i kdyz se jako FIFO zasobnik nechova
//Je to spis dynamicke pole, ale pouzivame to pro zasobnik, tak se to tak jmenuje
//****************************************************************************************************************
template <class dType> class CStack
{
private:
	dType*					m_Stack;
	unsigned int			m_size;
public:
	HRESULT					Init(int size = 1);
	unsigned int			Size()					{return m_size;}

	dType&					operator [] (unsigned int index);

	CStack(void);
	~CStack(void);
};
//****************************************************************************************************************
//Konstruktor
//****************************************************************************************************************
template <class dType> CStack<dType>::CStack()
{
	m_Stack = NULL;
	m_size = 0;
}
//****************************************************************************************************************
//Destruktor
//****************************************************************************************************************
template <class dType> CStack<dType>::~CStack()
{
	if (m_Stack)
		delete [] m_Stack;
}
//****************************************************************************************************************
//Inicializace zasobniku
//****************************************************************************************************************
template <class dType> HRESULT CStack<dType>::Init(int size)
{
	m_Stack = new dType[size];

	if (m_Stack)
	{
		m_size = size;
		return S_OK;
	}

	return E_POINTER;
}
//****************************************************************************************************************
//operator pro vyber z pole
//****************************************************************************************************************
template <class dType> dType& CStack<dType>::operator [] (unsigned int index)
{
	/*if (index > m_size)
		return*/;

	return m_Stack[index];
}
